%% Raw Photometry Data and MEDPC K Matrix Data Compiler - 10 trial bins
% This is the base code for processing the raw photometry data and aligning
% the data with the MEDPC K matrix data. Each session is processed with
% trials in a session processed in bins of 10. 

%% Load Photometry and K Matrix Data

% Across 100 pics

clear file1 path1 file2 path2 a_str d_str r_str filename kname dataname run_list    % Clears variables before opening files
k_base='E:\Multisite_Photometry\MedPC\KMatrix\';   % This is the folder the program will look for K Matrix Files
[file1,path1]=uigetfile('E:\Multisite_Photometry\MedPC\*.mat','Open .mat file','MultiSelect','on'); % Open dialog window to select .mat files
    if iscell(file1)==0 % If the output variable of the file names opened is a cell, then it needs to be rearranged to a column array
    disp(file1)
    else 
    disp(file1')
    end
    
% This is old code where you had to input and match both the .mat and k matrix file. 

% [file2,path2]=uigetfile('E:\K Matrix Files\*.csv','Open K Matrix file','MultiSelect','on');
%     if iscell(file2)==0
%     disp(file2)
%     else
%     disp(file2')
%     end
    

% if ischar(path2)== logical(0)
%     error('Did not load K Matrix file!')
% end

% Finds corresponding K Matrix files for the .mat files loaded
if iscell(file1)==0  % If only 1 .mat file is loaded
    dataname=strcat(path1,file1); % Full path name
    filename=file1;
        if file1(end-8:end-6)~='Run' %If the .mat file has INC at end of name
        a_str=file1(21:end-14); % Animal Name
        r_str=file1(end-8); % Run 1 or Run 2
        d_str=file1(12:19); % Date
        else
        a_str=file1(21:end-10); % Animal Name
        r_str=file1(end-4); % Run 1 or Run 2
        d_str=file1(12:19); % Date
        end
    path2=strcat(k_base,a_str,'\'); % Path of corresponding K Matrix file
    run_list= sprintf('%s %s % s',a_str,d_str,r_str); % Store name of run
    a_str=a_str(find(~isspace(a_str))); % Remove spaces in name
    month=d_str(1:2); 
    date=d_str(4:5);
    year=d_str(7:8);
    file2=sprintf('%s_%s_%s-0%s_%s.csv',a_str,month,date,r_str,year); % Full file name of corresponding K Matrix file 
    kname=strcat(path2,file2); % Path + name of K matrix file
    if exist(kname,'file')==0 % Check if K Matrix file exists
        error('%s does not exist!',file2); % Error code if K Matrix does not exist, breaks code
    end
    % If the file does exist
    disp(file2); % Displays the name of the corresponding K Matrix file
    
elseif iscell(file1)==1 % If muliple .mat files are loaded
    err_count=0; % Counter variable for # of K Matrix files not loaded
    for i=1:length(file1) % # of file names loaded
        
        dataname{i,:}=strcat(path1,file1{i}); % Full path name
        filename{i,:}=file1{i};
        file1_n=file1{i};  % Current loop iteration file name
        if file1_n(end-8:end-6)~='Run' %If the .mat file has INC at end of name
        a_str=file1_n(21:end-14); % Animal name
        r_str=file1_n(end-8); % Run 1 or Run 2
        d_str=file1_n(12:19); % Date
        else
        a_str=file1_n(21:end-10);
        r_str=file1_n(end-4);
        d_str=file1_n(12:19);
        end
        
        path2=strcat(k_base,a_str,'\'); % Path of corresponding K Matrix file
        run_list(i,:)= sprintf('%s %s % s',a_str,d_str,r_str); % Store name of run
        a_str=a_str(find(~isspace(a_str))); % Remove space from animal name
        month=d_str(1:2);
        date=d_str(4:5);
        year=d_str(7:8);
        file2=sprintf('%s_%s_%s-0%s_%s.csv',a_str,month,date,r_str,year); % Full file name of corresponding K Matrix file 
        kname{i,:}=strcat(path2,file2); % Path + name of K matrix file
        if exist(kname{i,:},'file')==0 % Check if current iteration K matrix file exists
            fprintf('%s does not exist!\n',file2); % Print the name of missing file
            err_count=err_count+1; % Increment error count
        else % If the file does exist
            disp(file2); % Displays the name of the corresponding K Matrix file
        end
    end
    if err_count~=0  % If the error count is > 0
        error('%d K matrix files were missing!',err_count) % Error code, display how many files were missing
    end
end

dataname=string(dataname); % Converts cell to string array, necessary for later code
kname=string(kname);
filename=string(filename);
run_list=string(run_list);
%% Stuff - Regression processing
max_lag=10; %Sets maximum lag time for cross-correlation calculation

% Dialog window asking to save all of the processed data files
choice = questdlg(sprintf('Save all selected files?'), ...
'Save Avg Data', ...
'Yes','No','Yes');
switch choice   % Creates the 2 selection button choices- Yes or No
    case 'Yes'  % Yes, save all files
        saveall=1;  % Saveall counter, 1 = save all, 0 = choose for each individual file
        cd 'E:\Multisite_Photometry\MedPC\Output'  % Default folder for where to save the processed files
        allpath=uigetdir('E:\Multisite_Photometry\MedPC\Output'); % Choose folder location to save processed files
    case 'No' % No, choose the location for each individual file
        saveall=0; % Saveall counter, 1 = save all, 0 = choose for each individual file
end
% Summary data matrices
sig1_sum.correct=[]; %All correct trials for all processed sessions
sig1_sum.omission=[]; %All omission trials for all processed sessions
press_sum.press1=[]; %All press signal for all processed sessions
press_sum.presslast=[];
press_sum.presspersev=[];
reward_sum.rew1=[]; %All reward signal for all processed sessions
entry_sum.all=[];
entry_sum.corr=[];
entry_sum.omit=[];

sig1_avg_total.correct = []; % Average signal for each individual session
sig1_avg_total.omission = [];
press_avg_total.press1=[];
press_avg_total.presslast=[];
press_avg_total.presspersev=[];
reward_avg_total.rew1=[];
entry_avg_total.all=[];
entry_avg_total.corr=[];
entry_avg_total.omit=[];

cnum_total=[]; % Total correct over all sessions
onum_total=[]; % Total omission over all sessions
p1num_total=[]; % Total presses over all sessions
plnum_total=[]; 
ppnum_total=[];
r1num_total=[]; % Total rewards over all sessions
enumall_total=[];
enumcorr_total=[];
enumomit_total=[];

for j=1:size(dataname,1)  % Loop through each loaded raw data file and corresponding K matrix file
    clear sig1_br sig2_br sig1_pr sig2_pr ...  % Clear these variables before the start of each loop iteration
          sig1_br_resid sig1_pr_resid sig2_br_resid sig2_pr_resid... 
          sig1_resid sig2_resid full_sig trial_count pm_count...
          sig1_str sig2_str
    load(dataname(j)); % Load .mat file
    k_data=xlsread(kname(j)); % Read K matrix
    [nImgs,nTrials]=size(sig1_br); %nImgs = # of Imgs per trial, nTrials = # of Trials total
    
    % Preallocate variables to increase processing speed
    % Std calcuation variable
    std1=[];  
    std2=[];
    std3=[];
    std4=[];
    std5=[];
    std6=[];
    std1_r=[];  
    std2_r=[];
    std3_r=[];
    std4_r=[];
    std5_r=[];
    std6_r=[];
    
    % Placeholder variable for studentized residuals calcuation
    nVec_sig1_b=[];
    nVec_sig2_b=[];
    nVec_sig1_p=[];
    nVec_sig2_p=[];
    nVec_sig1_br=[];
    nVec_sig2_br=[];
    nVec_sig1_pr=[];
    nVec_sig2_pr=[];
    nVec_sig1=[];
    nVec_sig2=[];
    nVec_sig1r=[];
    nVec_sig2r=[];
    
    % Processed signal structs, sorted by trial type
    sig1.correct=[];
    sig1.omission=[];
    
    sig2.correct=[];
    sig2.omission=[];

    
    % Aligned signal variables
    press_sig1.press1=[]; % Signal aligned to correct press
    press_sig2.press1=[]; 
    press_sig1.presslast=[]; 
    press_sig2.presslast=[]; 
    press_sig1.presspersev=[]; 
    press_sig2.presspersev=[];
   
    reward_sig1.rew1=[]; % Signal aligned to first reward entry
    reward_sig2.rew1=[]; 

    entry_sig1.all=[]; % Signal aligned to all pre-press head entries
    entry_sig2.all=[]; 
    entry_sig1.corr=[]; % Signal aligned to all pre-press head entries
    entry_sig2.corr=[]; 
    entry_sig1.omit=[]; % Signal aligned to all pre-press head entries
    entry_sig2.omit=[];     
    
    
    % Basically same thing as clear, just a precaution
    sig1_br_resid=[];
    sig2_br_resid=[];
    sig1_pr_resid=[];
    sig2_pr_resid=[];
    
    % Placeholder variables for 10 trial bins
    sig1_br_r1=[];
    sig2_br_r1=[];
    sig1_pr_r1=[];
    sig2_pr_r1=[];
    corrsigbr_r1=[];
    corrsigpr_r1=[];
    corrsigbr_r2=[];
    corrsigpr_r2=[];
    sig1_br_r2=[];
    sig2_br_r2=[];
    sig1_pr_r2=[];
    sig2_pr_r2=[];
    sig1_br_resid_r=[];
    sig2_br_resid_r=[];
    sig1_pr_resid_r=[];
    sig2_pr_resid_r=[];
    
    
% Binning Trials- The raw processed photometry data matrices are shaped so
% that each column is a trial, and the rows are the images obtained at a 
% specific time point. To bin the data into 10 trials, the matrix needs to
% be reshaped. This causes an issue if the number of trials is not
% divisible by 10, which this code takes into account.

% So if a session has 65 trials, with 100 images per trial,
% the data is going to be stored in 100 x 65 matrices. The binned matrices
% then will be a 1000 x 6 matrices, since 10 trials = 1000 images, and
% there will be 6 bins of ten. The last five remainder trials are the 7th
% and final bin. So for coding, the implementation involves
% finding the remainder of the total number of trials/10, which equals the
% number of trials in the final bin. The matrix is then reshaped for trials
% 1 to (# of Trials - remainder), and the remainder trials are stored in a
% separate array. 

    r=mod(nTrials,10); % Finds the remainder, 10 = # of bins. CHANGE IF YOU NEED A DIFFERENT BIN SIZE
    
if r ~= 0 % If there are remainder trials
    % Reshape the matrix for for Trials 1 to (# of Trials - remainder)
    sig1_br_r1=reshape(sig1_br(:,1:end-r),nImgs*10,(nTrials-r)/10);
    sig2_br_r1=reshape(sig2_br(:,1:end-r),nImgs*10,(nTrials-r)/10);
    sig1_pr_r1=reshape(sig1_pr(:,1:end-r),nImgs*10,(nTrials-r)/10);
    sig2_pr_r1=reshape(sig2_pr(:,1:end-r),nImgs*10,(nTrials-r)/10);
    % Reshape the remainder trials into a 1 dimensional array
    sig1_br_r2=reshape(sig1_br(:,end-r+1:end),r*nImgs,1);
    sig2_br_r2=reshape(sig2_br(:,end-r+1:end),r*nImgs,1);
    sig1_pr_r2=reshape(sig1_pr(:,end-r+1:end),r*nImgs,1);
    sig2_pr_r2=reshape(sig2_pr(:,end-r+1:end),r*nImgs,1);
    % Repeat previous steps for correction signal
    corrsigbr_r1=reshape(corrsigbr(:,1:end-r),nImgs*10,(nTrials-r)/10);
    corrsigpr_r1=reshape(corrsigpr(:,1:end-r),nImgs*10,(nTrials-r)/10);
    corrsigbr_r2=reshape(corrsigbr(:,end-r+1:end),r*nImgs,1);
    corrsigpr_r2=reshape(corrsigpr(:,end-r+1:end),r*nImgs,1);

% Regress the laser energy correction fiber signal from the blue and violet
% laser signal

% Matlab's regression function requires that the predictors (expected) 
% value matrix, which in our case is the correction signal, has a column of 
% just 1s for the 1st column. 
    
    for k=1:(nTrials-r)/10 % Loop through each bin of 10 and perform the regression to find the residuals
        [~,~,sig1_br_resid(:,k)]=regress(sig1_br_r1(:,k),[ones(nImgs*10,1) corrsigbr_r1(:,k)]);
        [~,~,sig2_br_resid(:,k)]=regress(sig2_br_r1(:,k),[ones(nImgs*10,1) corrsigbr_r1(:,k)]);
        [~,~,sig1_pr_resid(:,k)]=regress(sig1_pr_r1(:,k),[ones(nImgs*10,1) corrsigpr_r1(:,k)]);
        [~,~,sig2_pr_resid(:,k)]=regress(sig2_pr_r1(:,k),[ones(nImgs*10,1) corrsigpr_r1(:,k)]);
    end
    
% Residuals have normal distributions with zero mean but with different 
% variances at different values of the predictors. To place the residuals
% on a comparable scale, they need to be studentized, which converts them 
% to z-scores. The formula is a little too complex to put here, 
% but for further details:
% https://www.mathworks.com/help/stats/residuals.html
% https://www.mathworks.com/help/stats/regress.html?s_tid=doc_ta
% In layman's terms, for any one residual out of all the residuals in the
% regression model, the studentized residual is the raw residual divided by 
% the standard deviation of all of the residuals, excluding the observation 
% point. So for a set of 4 residuals r1, r2, r3, and r4, r1 studentized =
% r1/std(r2, r3, r4), r2 studentized = r2/std(r1, r3, r4), etc...
% To implement this coding-wise, we take advantage of Matlab's matrix
% calculation capabilities. We go through row by row and calculate the
% standard deviation of each column, with the current row excluded. The
% standard deviations for each residual point are saved to a separate
% matrix, and at the end, we ./ the residual matrices with the std
% matrices. 

    % Find residuals for the final bin
    [~,~,sig1_br_resid_r]=regress(sig1_br_r2,[ones(nImgs*r,1) corrsigbr_r2]);
    [~,~,sig2_br_resid_r]=regress(sig2_br_r2,[ones(nImgs*r,1) corrsigbr_r2]);
    [~,~,sig1_pr_resid_r]=regress(sig1_pr_r2,[ones(nImgs*r,1) corrsigpr_r2]);
    [~,~,sig2_pr_resid_r]=regress(sig2_pr_r2,[ones(nImgs*r,1) corrsigpr_r2]);
    
 


    for k=1:nImgs*10 % Loop through each row in the residual matrices
        nVec_sig1_b=sig1_br_resid; % Copy the residual matrix
        nVec_sig1_b(k,:)=[]; % Delete the current row to exclude the points for the std calculation
        std1(k,:)=std(nVec_sig1_b); % Calculate the std for each column.

        nVec_sig2_b=sig2_br_resid;
        nVec_sig2_b(k,:)=[];
        std2(k,:)=std(nVec_sig2_b);

        nVec_sig1_p=sig1_pr_resid;
        nVec_sig1_p(k,:)=[];
        std3(k,:)=std(nVec_sig1_p);

        nVec_sig2_p=sig2_pr_resid;
        nVec_sig2_p(k,:)=[];
        std4(k,:)=std(nVec_sig2_p);
    end
    
    sig1_br_resid=sig1_br_resid./std1; % Convert residuals to z-scores
    sig2_br_resid=sig2_br_resid./std2;
    sig1_pr_resid=sig1_pr_resid./std3;
    sig2_pr_resid=sig2_pr_resid./std4;
    
    for k=1:nImgs*r % Loop through each row in the residual matrices for the remainder trials
        nVec_sig1_br=sig1_br_resid_r;
        nVec_sig1_br(k,:)=[];
        std1_r(k,:)=std(nVec_sig1_br);

        nVec_sig2_br=sig2_br_resid_r;
        nVec_sig2_br(k,:)=[];
        std2_r(k,:)=std(nVec_sig2_br);

        nVec_sig1_pr=sig1_pr_resid_r;
        nVec_sig1_pr(k,:)=[];
        std3_r(k,:)=std(nVec_sig1_pr);

        nVec_sig2_pr=sig2_pr_resid_r;
        nVec_sig2_pr(k,:)=[];
        std4_r(k,:)=std(nVec_sig2_pr);
    end
    
    sig1_br_resid_r=sig1_br_resid_r./std1_r;
    sig2_br_resid_r=sig2_br_resid_r./std2_r;
    sig1_pr_resid_r=sig1_pr_resid_r./std3_r;
    sig2_pr_resid_r=sig2_pr_resid_r./std4_r;
    
%     sig1_br_resid_r1=reshape(sig1_br_resid(:,1:end-r),nImgs*10,(nTrials-r)/10);
%     sig2_br_resid_r1=reshape(sig2_br_resid(:,1:end-r),nImgs*10,(nTrials-r)/10);
%     sig1_pr_resid_r1=reshape(sig1_pr_resid(:,1:end-r),nImgs*10,(nTrials-r)/10);
%     sig2_pr_resid_r1=reshape(sig2_pr_resid(:,1:end-r),nImgs*10,(nTrials-r)/10);
%     sig1_br_resid_r2=reshape(sig1_br_resid(:,end-r+1:end),r*nImgs,1);
%     sig2_br_resid_r2=reshape(sig2_br_resid(:,end-r+1:end),r*nImgs,1);
%     sig1_pr_resid_r2=reshape(sig1_pr_resid(:,end-r+1:end),r*nImgs,1);
%     sig2_pr_resid_r2=reshape(sig2_pr_resid(:,end-r+1:end),r*nImgs,1);

% Regress the isosbestic violet signal from the blue signal to get the
% final denoised signal

    for k=1:(nTrials-r)/10
        [~,~,sig1_resid(:,k)]=regress(sig1_br_resid(:,k),[ones(nImgs*10,1) sig1_pr_resid(:,k)]);
        [~,~,sig2_resid(:,k)]=regress(sig2_br_resid(:,k),[ones(nImgs*10,1) sig2_pr_resid(:,k)]);
    end

    [~,~,sig1_resid_r]=regress(sig1_br_resid_r,[ones(nImgs*r,1) sig1_pr_resid_r]);
    [~,~,sig2_resid_r]=regress(sig2_br_resid_r,[ones(nImgs*r,1) sig2_pr_resid_r]);

% Studentize residuals to get z-scores

    for k=1:nImgs*10
            
        nVec_sig1=sig1_resid;
        nVec_sig1(k,:)=[];
        std5(k,:)=std(nVec_sig1);

        nVec_sig2=sig2_resid;
        nVec_sig2(k,:)=[];
        std6(k,:)=std(nVec_sig2);

    end
    sig1_resid=sig1_resid./std5;
    sig2_resid=sig2_resid./std6;
    
    for k=1:nImgs*r
            
        nVec_sig1r=sig1_resid_r;
        nVec_sig1r(k,:)=[];
        std5_r(k,:)=std(nVec_sig1r);

        nVec_sig2r=sig2_resid_r;
        nVec_sig2r(k,:)=[];
        std6_r(k,:)=std(nVec_sig2r);

    end
    sig1_resid_r=sig1_resid_r./std5_r;
    sig2_resid_r=sig2_resid_r./std6_r;

    % Reshape the filtered signals back to original matrix: Rows = Images,
    % Columns = Trials
    
    sig1_resid_r=reshape(sig1_resid_r,nImgs,r);
    sig2_resid_r=reshape(sig2_resid_r,nImgs,r);
    
    sig1_resid=reshape(sig1_resid,nImgs,nTrials-r);
    sig2_resid=reshape(sig2_resid,nImgs,nTrials-r);
    
    sig1_resid=cat(2,sig1_resid,sig1_resid_r);
    sig2_resid=cat(2,sig2_resid,sig2_resid_r);
    
    sig1_br_resid=reshape(sig1_br_resid,nImgs,nTrials-r);
    sig2_br_resid=reshape(sig2_br_resid,nImgs,nTrials-r);
    sig1_pr_resid=reshape(sig1_pr_resid,nImgs,nTrials-r);
    sig2_pr_resid=reshape(sig2_pr_resid,nImgs,nTrials-r);
    
    sig1_br_resid_r=reshape(sig1_br_resid_r,nImgs,r);
    sig2_br_resid_r=reshape(sig2_br_resid_r,nImgs,r);
    sig1_pr_resid_r=reshape(sig1_pr_resid_r,nImgs,r);
    sig2_pr_resid_r=reshape(sig2_pr_resid_r,nImgs,r);
    
    sig1_br_resid=cat(2,sig1_br_resid,sig1_br_resid_r);
    sig2_br_resid=cat(2,sig2_br_resid,sig2_br_resid_r);
    sig1_pr_resid=cat(2,sig1_pr_resid,sig1_pr_resid_r);
    sig2_pr_resid=cat(2,sig2_pr_resid,sig2_pr_resid_r);

else % If there are no remainder trials
    % Reshape the matrix
    sig1_br_r1=reshape(sig1_br,nImgs*10,nTrials/10);
    sig2_br_r1=reshape(sig2_br,nImgs*10,nTrials/10);
    sig1_pr_r1=reshape(sig1_pr,nImgs*10,nTrials/10);
    sig2_pr_r1=reshape(sig2_pr,nImgs*10,nTrials/10);

    corrsigbr_r1=reshape(corrsigbr,nImgs*10,nTrials/10);
    corrsigpr_r1=reshape(corrsigpr,nImgs*10,nTrials/10);


% Regress the laser energy correction fiber signal from the blue and violet
% laser signal

% Matlab's regression function requires that the predictors (expected) 
% value matrix, which in our case is the correction signal, has a column of 
% just 1s for the 1st column. 
    
    for k=1:nTrials/10 % Loop through each bin of 10 and perform the regression to find the residuals
        [~,~,sig1_br_resid(:,k)]=regress(sig1_br_r1(:,k),[ones(nImgs*10,1) corrsigbr_r1(:,k)]);
        [~,~,sig2_br_resid(:,k)]=regress(sig2_br_r1(:,k),[ones(nImgs*10,1) corrsigbr_r1(:,k)]);
        [~,~,sig1_pr_resid(:,k)]=regress(sig1_pr_r1(:,k),[ones(nImgs*10,1) corrsigpr_r1(:,k)]);
        [~,~,sig2_pr_resid(:,k)]=regress(sig2_pr_r1(:,k),[ones(nImgs*10,1) corrsigpr_r1(:,k)]);
    end

    for k=1:nImgs*10 
        nVec_sig1_b=sig1_br_resid; 
        nVec_sig1_b(k,:)=[]; 
        std1(k,:)=std(nVec_sig1_b); 

        nVec_sig2_b=sig2_br_resid;
        nVec_sig2_b(k,:)=[];
        std2(k,:)=std(nVec_sig2_b);

        nVec_sig1_p=sig1_pr_resid;
        nVec_sig1_p(k,:)=[];
        std3(k,:)=std(nVec_sig1_p);

        nVec_sig2_p=sig2_pr_resid;
        nVec_sig2_p(k,:)=[];
        std4(k,:)=std(nVec_sig2_p);
    end
    
    sig1_br_resid=sig1_br_resid./std1; % Divide the residuals by the std to studentize
    sig2_br_resid=sig2_br_resid./std2;
    sig1_pr_resid=sig1_pr_resid./std3;
    sig2_pr_resid=sig2_pr_resid./std4;
    

    for k=1:nTrials/10
        [~,~,sig1_resid(:,k)]=regress(sig1_br_resid(:,k),[ones(nImgs*10,1) sig1_pr_resid(:,k)]);
        [~,~,sig2_resid(:,k)]=regress(sig2_br_resid(:,k),[ones(nImgs*10,1) sig2_pr_resid(:,k)]);
    end
    
    for k=1:nImgs*10
            
        nVec_sig1=sig1_resid;
        nVec_sig1(k,:)=[];
        std5(k,:)=std(nVec_sig1);

        nVec_sig2=sig2_resid;
        nVec_sig2(k,:)=[];
        std6(k,:)=std(nVec_sig2);

    end
    sig1_resid=sig1_resid./std5;
    sig2_resid=sig2_resid./std6;
    
    sig1_resid=reshape(sig1_resid,nImgs,nTrials);
    sig2_resid=reshape(sig2_resid,nImgs,nTrials);
    
    sig1_br_resid=reshape(sig1_br_resid,nImgs,nTrials);
    sig2_br_resid=reshape(sig2_br_resid,nImgs,nTrials);
    sig1_pr_resid=reshape(sig1_pr_resid,nImgs,nTrials);
    sig2_pr_resid=reshape(sig2_pr_resid,nImgs,nTrials);
    
    
end
    

%% Sorting the processed photometry data using K Matrix data
% EDIT THIS LOOP BELOW TO CHANGE ALIGNMENT/DATA OUTPUT

    for i=1:nTrials  % Loop through each trial
        if k_data(i,6)==1 %% Omission
            sig1.omission(:,end+1)=sig1_resid(:,i); %Get omission signal from ROI 1
            sig2.omission(:,end+1)=sig2_resid(:,i);
            sig1_sum.omission(:,end+1)=sig1_resid(:,i); %Store signal
            
        elseif k_data(i,6)==0  %% 1st Correct - press 
            sig1.correct(:,end+1)=sig1_resid(:,i); %Get correct 1st press signal from ROI 1
            sig2.correct(:,end+1)=sig2_resid(:,i);
            sig1_sum.correct(:,end+1)=sig1_resid(:,i); %Store signal
            
            start_press=str2num(sprintf('%0.1f',k_data(i,8))); % Convert k matrix time value
            pre_press=((start_press+3)*10)-30; % Find 3s prior to press
            post_press=((start_press+3)*10)+30; % Find 3s after press
            if post_press <= nImgs %If within 3s bounds
                press_sig1.press1(:,end+1)=sig1_resid((pre_press:post_press),i); % Press signal
                press_sig2.press1(:,end+1)=sig2_resid((pre_press:post_press),i);
                press_sum.press1(:,end+1)=sig1_resid((pre_press:post_press),i); % Store press signal
 
            elseif post_press > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_press+1; % Get length of extra time
                sig1_vec = NaN((post_press-pre_press+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_press-pre_press+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                press_sig1.press1(:,end+1)= sig1_vec; % Press signal
                press_sig2.press1(:,end+1)= sig2_vec;
                press_sum.press1(:,end+1)= sig1_vec; % Store press signal
            end
               if k_data(i,7)~=0 %%last perseverative press
               start_press=str2num(sprintf('%0.1f',k_data(i,7))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press
                if post_press <= nImgs
                    press_sig1.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i); % perseverative press
                    press_sig2.presspersev(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i);
                    
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);
                    
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);  
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                    press_sig1.presspersev(:,end+1)= sig1_vec;    % perseverative press
                    press_sig2.presspersev(:,end+1)= sig2_vec;
                    press_sum.presspersev(:,end+1)=sig1_vec;
                    
                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
               elseif k_data(i,7)==0 
               start_press=str2num(sprintf('%0.1f',k_data(i,8))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press    
                if post_press <= nImgs
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);   
               
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);  
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);       
                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
            end
            
            if k_data(i,10)~=0  %% 2nd Correct - Press              
                start_press=str2num(sprintf('%0.1f',k_data(i,10))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press
                if post_press <= nImgs
                    press_sig1.press1(:,end+1)=sig1_resid((pre_press:post_press),i);
                    press_sig2.press1(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.press1(:,end+1)=sig1_resid((pre_press:post_press),i);
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                    press_sig1.press1(:,end+1)= sig1_vec;
                    press_sig2.press1(:,end+1)= sig2_vec;
                    press_sum.press1(:,end+1)=sig1_vec;
                end
               if k_data(i,14)~=0 %%last perseverative press
               start_press=str2num(sprintf('%0.1f',k_data(i,14))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press
                if post_press <= nImgs
                    press_sig1.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i);
                    press_sig2.presspersev(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i);
                    
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                    press_sig1.presspersev(:,end+1)= sig1_vec;
                    press_sig2.presspersev(:,end+1)= sig2_vec;
                    press_sum.presspersev(:,end+1)= sig1_vec;
                                        
                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
                
               elseif k_data(i,14)==0 
               start_press=str2num(sprintf('%0.1f',k_data(i,10))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press    
                if post_press <= nImgs
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);   
               
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);  
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);       
                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
               end
            
            
            if k_data(i,12)~=0  %% 3rd Correct - Press              
                start_press=str2num(sprintf('%0.1f',k_data(i,12))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press
                if post_press <= nImgs
                    press_sig1.press1(:,end+1)=sig1_resid((pre_press:post_press),i);
                    press_sig2.press1(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.press1(:,end+1)=sig1_resid((pre_press:post_press),i);
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                    press_sig1.press1(:,end+1)= sig1_vec;
                    press_sig2.press1(:,end+1)= sig2_vec;
                    press_sum.press1(:,end+1)=sig1_vec;
                end
               if k_data(i,15)~=0 %%last perseverative press
               start_press=str2num(sprintf('%0.1f',k_data(i,15))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press
                if post_press <= nImgs
                    press_sig1.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i);
                    press_sig2.presspersev(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presspersev(:,end+1)=sig1_resid((pre_press:post_press),i);
                    
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);
                    
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);               
                    press_sig1.presspersev(:,end+1)= sig1_vec;
                    press_sig2.presspersev(:,end+1)= sig2_vec;
                    press_sum.presspersev(:,end+1)=sig1_vec;

                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
               elseif k_data(i,15)==0 
               start_press=str2num(sprintf('%0.1f',k_data(i,12))); % Convert k matrix time value
                pre_press=((start_press+3)*10)-30; % Find 3s prior to press
                post_press=((start_press+3)*10)+30; % Find 3s after press    
                if post_press <= nImgs
                    press_sig1.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);  % last press
                    press_sig2.presslast(:,end+1)=sig2_resid((pre_press:post_press),i);
                    press_sum.presslast(:,end+1)=sig1_resid((pre_press:post_press),i);   
               
                elseif post_press > nImgs
                    sig_length= nImgs-pre_press+1; 
                    sig1_vec = NaN((post_press-pre_press+1),1);  
                    sig2_vec = NaN((post_press-pre_press+1),1);
                    sig1_vec(1:sig_length)= sig1_resid((pre_press:nImgs),i);
                    sig2_vec(1:sig_length)= sig2_resid((pre_press:nImgs),i);       
                    press_sig1.presslast(:,end+1)= sig1_vec;      % last press
                    press_sig2.presslast(:,end+1)= sig2_vec;
                    press_sum.presslast(:,end+1)=sig1_vec;
                end
               end
            end
            end
        end

       if k_data(i,9)~=0 && k_data(i,9)~=8.05  %% 1st Reward 
            start_rew=str2num(sprintf('%0.1f',(k_data(i,8))+(k_data(i,9)))); % Convert k matrix time value
            pre_rew=((start_rew+3)*10)-30; % Find 3s prior to press
            post_rew=((start_rew+3)*10)+30; % Find 3s after press
            if post_rew <= nImgs %If within 3s bounds
                reward_sig1.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % reward signal
                reward_sig2.rew1(:,end+1)=sig2_resid((pre_rew:post_rew),i);
                reward_sum.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % Store press signal
 
            elseif post_rew > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_rew+1; % Get length of extra time
                sig1_vec = NaN((post_rew-pre_rew+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_rew-pre_rew+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_rew:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_rew:nImgs),i);               
                reward_sig1.rew1(:,end+1)= sig1_vec; % Press signal
                reward_sig2.rew1(:,end+1)= sig2_vec;
                reward_sum.rew1(:,end+1)= sig1_vec; % Store press signal
            end
            if k_data(i,11)~=0 && k_data(i,11)~=8.05 %% 2nd Correct - reward              
                start_rew=str2num(sprintf('%0.1f',(k_data(i,10))+(k_data(i,11)))); % Convert k matrix time value
             pre_rew=((start_rew+3)*10)-30; % Find 3s prior to press
            post_rew=((start_rew+3)*10)+30; % Find 3s after press
            if post_rew <= nImgs %If within 3s bounds
                reward_sig1.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % reward signal
                reward_sig2.rew1(:,end+1)=sig2_resid((pre_rew:post_rew),i);
                reward_sum.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % Store press signal
 
            elseif post_rew > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_rew+1; % Get length of extra time
                sig1_vec = NaN((post_rew-pre_rew+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_rew-pre_rew+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_rew:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_rew:nImgs),i);               
                reward_sig1.rew1(:,end+1)= sig1_vec; % Press signal
                reward_sig2.rew1(:,end+1)= sig2_vec;
                reward_sum.rew1(:,end+1)= sig1_vec; % Store press signal
                end
            end
            if k_data(i,13)~=0 && k_data(i,13)~=8.05 %% 3rd Correct - Reward              
                start_rew=str2num(sprintf('%0.1f',(k_data(i,12))+(k_data(i,13)))); % Convert k matrix time value
            pre_rew=((start_rew+3)*10)-30; % Find 3s prior to reward
            post_rew=((start_rew+3)*10)+30; % Find 3s after reward
            if post_rew <= nImgs %If within 3s bounds
                reward_sig1.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % reward signal
                reward_sig2.rew1(:,end+1)=sig2_resid((pre_rew:post_rew),i);
                reward_sum.rew1(:,end+1)=sig1_resid((pre_rew:post_rew),i); % Store press signal
 
            elseif post_rew > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_rew+1; % Get length of extra time
                sig1_vec = NaN((post_rew-pre_rew+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_rew-pre_rew+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_rew:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_rew:nImgs),i);               
                reward_sig1.rew1(:,end+1)= sig1_vec; % Press signal
                reward_sig2.rew1(:,end+1)= sig2_vec;
                reward_sum.rew1(:,end+1)= sig1_vec; % Store press signal
                end
            end
    
            
       end
    
        if k_data(i,6)==0  %%  Pre-press head entries - Correct trials
         if k_data(i,16)~=0 && k_data(i,16)>.1          
            start_entry=str2num(sprintf('%0.1f',k_data(i,16))); % Convert k matrix time value
            if ((start_entry+3)*10) <= nImgs
            pre_entry=((start_entry+3)*10)-30; % Find 3s prior to press
            post_entry=((start_entry+3)*10)+30; % Find 3s after press
            if post_entry <= nImgs %If within 3s bounds
                entry_sig1.corr(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig1.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig2.corr(:,end+1)=sig2_resid((pre_entry:post_entry),i);
                entry_sum.corr(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store press signal
                entry_sum.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store press signal
                
            elseif post_entry > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_entry+1; % Get length of extra time
                sig1_vec = NaN((post_entry-pre_entry+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_entry-pre_entry+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_entry:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_entry:nImgs),i);               
                entry_sig1.corr(:,end+1)= sig1_vec; % entry signal
                entry_sig1.all(:,end+1)= sig1_vec; % entry signal
                entry_sig2.corr(:,end+1)= sig2_vec;
                entry_sum.corr(:,end+1)= sig1_vec; % Store entry signal
                entry_sum.all(:,end+1)= sig1_vec; % Store entry signal
            end
            end
            
            if k_data(i,17)~=0 && k_data(i,17)>.1          
            start_entry=str2num(sprintf('%0.1f',k_data(i,17))); % Convert k matrix time value
            if start_entry <= nImgs
            pre_entry=((start_entry+3)*10)-30; % Find 3s prior to entry
            post_entry=((start_entry+3)*10)+30; % Find 3s after entry
            if post_entry <= nImgs %If within 3s bounds
                entry_sig1.corr(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig1.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig2.corr(:,end+1)=sig2_resid((pre_entry:post_entry),i);
                entry_sum.corr(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store entry signal
                entry_sum.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store entry signal
 
            elseif post_entry > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_entry+1; % Get length of extra time
                sig1_vec = NaN((post_entry-pre_entry+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_entry-pre_entry+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_entry:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_entry:nImgs),i);               
                entry_sig1.corr(:,end+1)= sig1_vec; % entry signal
                entry_sig1.all(:,end+1)= sig1_vec; % entry signal
                entry_sig2.corr(:,end+1)= sig2_vec;
                entry_sum.corr(:,end+1)= sig1_vec; % Store entry signal
                entry_sum.all(:,end+1)= sig1_vec; % Store entry signal
            end
            end
            end
         end
         
        elseif k_data(i,6)~=0  %%Pre-press head entries -Omission trials
            if k_data(i,16)~=0 && k_data(i,16)>.1          
            start_entry=str2num(sprintf('%0.1f',k_data(i,16))); % Convert k matrix time value
            if ((start_entry+3)*10) <= nImgs
            pre_entry=((start_entry+3)*10)-30; % Find 3s prior to press
            post_entry=((start_entry+3)*10)+30; % Find 3s after press
            if post_entry <= nImgs %If within 3s bounds
                entry_sig1.omit(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig1.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % entry signal
                entry_sig2.omit(:,end+1)=sig2_resid((pre_entry:post_entry),i);
                entry_sum.omit(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store press signal
                entry_sum.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store press signal
 
            elseif post_entry > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_entry+1; % Get length of extra time
                sig1_vec = NaN((post_entry-pre_entry+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_entry-pre_entry+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_entry:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_entry:nImgs),i);               
                entry_sig1.omit(:,end+1)= sig1_vec; % entry signal
                entry_sig1.all(:,end+1)= sig1_vec; % entry signal
                entry_sig2.omit(:,end+1)= sig2_vec;
                entry_sum.omit(:,end+1)= sig1_vec; % Store entry signal
                entry_sum.all(:,end+1)= sig1_vec; % Store entry signal
            end
            end
            
            if k_data(i,17)~=0 && k_data(i,17)>.1          
            start_entry=str2num(sprintf('%0.1f',k_data(i,17))); % Convert k matrix time value
            if start_entry <= nImgs
            pre_entry=((start_entry+3)*10)-30; % Find 3s prior to Entry
            post_entry=((start_entry+3)*10)+30; % Find 3s after Entry
            if post_entry <= nImgs %If within 3s bounds
                entry_sig1.omit(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Entry signal
                entry_sig1.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Entry signal
                entry_sig2.omit(:,end+1)=sig2_resid((pre_entry:post_entry),i);
                entry_sum.omit(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store Entry signal
                entry_sum.all(:,end+1)=sig1_resid((pre_entry:post_entry),i); % Store Entry signal
 
            elseif post_entry > nImgs   % 3s after press exceeds trial time limit
                sig_length= nImgs-pre_entry+1; % Get length of extra time
                sig1_vec = NaN((post_entry-pre_entry+1),1); %Creates NaN vectors
                sig2_vec = NaN((post_entry-pre_entry+1),1);
                sig1_vec(1:sig_length)= sig1_resid((pre_entry:nImgs),i); % Fills signal vector with signal value, NaN for missing
                sig2_vec(1:sig_length)= sig2_resid((pre_entry:nImgs),i);               
                entry_sig1.omit(:,end+1)= sig1_vec; % Entry signal
                entry_sig1.all(:,end+1)= sig1_vec; % Entry signal
                entry_sig2.omit(:,end+1)= sig2_vec;
                entry_sum.omit(:,end+1)= sig1_vec; % Store Entry signal
                entry_sum.all(:,end+1)= sig1_vec; % Store Entry signal
            end
            end
            end
         end
        end    
    end
        
     
    cnum=size(sig1.correct,2); % Get # of correct trials
    onum=size(sig1.omission,2); % Get # of omission trials
    p1num=size(press_sig1.press1,2); %Get # of press
    plnum=size(press_sig1.presslast,2); %Get # of last press
    ppnum=size(press_sig1.presspersev,2); %Get # of last perseverative press
    r1num=size(reward_sig1.rew1,2); %Get # of reward
    enumcorr=size(entry_sig1.corr,2); % Get # of pre-press entry trials (correct)
    enumomit=size(entry_sig1.omit,2); % Get # of pre-press entry trials (omission)\
    enumall=size(entry_sig1.all,2); % Get # of pre-press entry trials (omission)
    

    cnum_total(end+1,1)= cnum; % Total correct over all sessions
    onum_total(end+1,1) = onum; % Total omission over all sessions
    p1num_total(end+1,1)= p1num; % Total presses over all sessions
    plnum_total(end+1,1)= plnum;
    ppnum_total(end+1,1)= ppnum;
    r1num_total(end+1,1)= r1num; % Total rewards over all sessions
    enumall_total(end+1,1)= enumall;
    enumcorr_total(end+1,1)= enumcorr;
    enumomit_total(end+1,1)= enumomit;
    
    % Average data across trial types
    
    % Placeholder structs for average signal across all trials for each
    % trial type
    
    sig1_avg.correct=[];
    sig1_avg.omission=[];
    sig2_avg.correct=[];
    sig2_avg.omission=[];
    
    % Placeholder for 
    press_sig1_avg.press1=[];
    press_sig1_avg.presslast=[];
    press_sig1_avg.presspersev=[];
    
    press_sig2_avg.press1=[];
    press_sig2_avg.presslast=[];
    press_sig2_avg.presspersev=[];
    
    reward_sig1_avg.rew1=[];
    reward_sig2_avg.rew1=[];
    
    entry_sig1_avg.corr=[];
    entry_sig2_avg.corr=[];
    entry_sig1_avg.omit=[];
    entry_sig2_avg.omit=[];
    entry_sig1_avg.all=[];
    entry_sig2_avg.all=[];
    
    sig1_avg.correct=mean(sig1.correct,2); % Get average signal across all trials for 1 session
    sig1_avg.omission=mean(sig1.omission,2);
    sig2_avg.correct=mean(sig2.correct,2);
    sig2_avg.omission=mean(sig2.omission,2);
    sig1_avg.all=mean(sig1_resid,2);
    sig2_avg.all=mean(sig2_resid,2);
    
    press_sig1_avg.press1=mean(press_sig1.press1,2,'omitnan'); % find average press 1 signal, omits NaN values
    press_sig2_avg.press1=mean(press_sig2.press1,2,'omitnan');
    
    press_sig1_avg.presslast=mean(press_sig1.presslast,2,'omitnan'); % find average last press signal, omits NaN values
    press_sig2_avg.presslast=mean(press_sig2.presslast,2,'omitnan');
    
    press_sig1_avg.presspersev=mean(press_sig1.presspersev,2,'omitnan'); % find average persev press signal, omits NaN values
    press_sig2_avg.presspersev=mean(press_sig2.presspersev,2,'omitnan');
    
    reward_sig1_avg.rew1=mean(reward_sig1.rew1,2,'omitnan'); % find average reward 1 signal, omits NaN values
    reward_sig2_avg.rew1=mean(reward_sig2.rew1,2,'omitnan');
    
    entry_sig1_avg.corr=mean(entry_sig1.corr,2,'omitnan'); % find average pre-press entry signal, omits NaN values
    entry_sig2_avg.corr=mean(entry_sig2.corr,2,'omitnan');
    entry_sig1_avg.omit=mean(entry_sig1.omit,2,'omitnan'); % find average pre-press entry signal, omits NaN values
    entry_sig2_avg.omit=mean(entry_sig2.omit,2,'omitnan');
    entry_sig1_avg.all=mean(entry_sig1.all,2,'omitnan'); % find average pre-press entry signal, omits NaN values
    entry_sig2_avg.all=mean(entry_sig2.all,2,'omitnan');
    
    sig1_avg_total.correct(:,end+1)=sig1_avg.correct; % Average signal for each individual session
    sig1_avg_total.omission(:,end+1)=sig1_avg.omission;
    press_avg_total.press1(:,end+1)=press_sig1_avg.press1;
    press_avg_total.presslast(:,end+1)=press_sig1_avg.presslast;
    press_avg_total.presspersev(:,end+1)=press_sig1_avg.presspersev;
    reward_avg_total.rew1(:,end+1)=reward_sig1_avg.rew1;
   entry_avg_total.corr(:,end+1)=entry_sig1_avg.corr;
    entry_avg_total.omit(:,end+1)=entry_sig1_avg.omit;
    entry_avg_total.all(:,end+1)=entry_sig1_avg.all;


filestr=char(filename(j));
choicestr=filestr(12:end-4);
if saveall==1 %If saving all the files loaded
    fullpath=strcat(allpath,sprintf('\\AvgData_%s',choicestr));
    save(fullpath,'sig1_br_resid','sig2_br_resid','sig1_pr_resid','sig2_pr_resid',... % This lists the variables that are being saved
        'sig1_resid','sig2_resid',...
        'sig1_avg','sig2_avg',...
        'sig1_str','sig2_str','cnum','onum','p1num','plnum','ppnum','r1num','enumcorr','enumomit','enumall',...
        'press_sig1','press_sig2','press_sig1_avg','press_sig2_avg',...
        'reward_sig1','reward_sig2','entry_sig1','entry_sig2','reward_sig1_avg','reward_sig2_avg','entry_sig1_avg','entry_sig2_avg')
    fprintf('Saved %s!\n',choicestr)
else %Only saving some of the files
    choice = questdlg(sprintf('Save %s ?',choicestr), ... %Open dialog window for each session
    'Save Plots & Avg Data', ...
    'Yes','No','Yes');
    switch choice
        case 'Yes'
            cd 'E:\Multisite_Photometry\MedPC\Output'
            [file2,path2]=uiputfile('*.mat',sprintf('Save %s as...',dataname(j)),sprintf('AvgData_%s',choicestr));
            if file2==0
                continue
            end
            save(strcat(path2,file2),'sig1_br_resid','sig2_br_resid','sig1_pr_resid','sig2_pr_resid',...
        'sig1_resid','sig2_resid',...
        'sig1_avg','sig2_avg',...
        'sig1_str','sig2_str','cnum','onum','p1num','plnum','ppnum','r1num','enumcorr','enumomit','enumall',...
        'press_sig1','press_sig2','press_sig1_avg','press_sig2_avg',...
        'reward_sig1','reward_sig2','entry_sig1','entry_sig2','reward_sig1_avg','reward_sig2_avg','entry_sig1_avg','entry_sig2_avg')
        case 'No'
            continue
    end

end
end

%% Save summary excel file with compiled average data of all loaded files
sig1_sum_avg.correct=mean(sig1_sum.correct,2); % Get average of all correct trials for all sessions loaded
sig1_sum_avg.omission=mean(sig1_sum.omission,2); % Get average of all omission trials for all sessions loaded
press_sum_avg.press1=mean(press_sum.press1,2,'omitnan'); % find average press 1 signal, omits NaN values
press_sum_avg.presslast=mean(press_sum.presslast,2,'omitnan'); 
press_sum_avg.presspersev=mean(press_sum.presspersev,2,'omitnan'); 
reward_sum_avg.rew1=mean(reward_sum.rew1,2,'omitnan'); % find average reward signal, omits NaN values
entry_sum_avg.all=mean(entry_sum.all,2,'omitnan'); 
entry_sum_avg.corr=mean(entry_sum.corr,2,'omitnan'); 
entry_sum_avg.omit=mean(entry_sum.omit,2,'omitnan'); 


    choice = questdlg('Save summary excel data?', ...
    'Save summary excel data?', ...
    'Yes','No','Yes');  
    switch choice
        case 'Yes'
        name_sum=sprintf('%s\\shaping-PARTIAL.xlsx',allpath);
        xlswrite(name_sum,sig1_sum_avg.correct,sprintf('%s Correct Avg',sig1_str));
        xlswrite(name_sum,sig1_sum_avg.omission,sprintf('%s Omission Avg',sig1_str));
        xlswrite(name_sum,press_sum_avg.press1,sprintf('%s Press 1 Avg',sig1_str));
        xlswrite(name_sum,press_sum_avg.presslast,sprintf('%s Last press Avg',sig1_str));
        xlswrite(name_sum,press_sum_avg.presspersev,sprintf('%s Persev press Avg',sig1_str));
        xlswrite(name_sum,reward_sum_avg.rew1,sprintf('%s Reward 1 Avg',sig1_str));
        xlswrite(name_sum,entry_sum_avg.all,sprintf('%s All Pre-press entry Avg',sig1_str));
     if isempty(entry_sum_avg.corr)== 0
        xlswrite(name_sum,entry_sum_avg.corr,sprintf('%s Corr Pre-press entry Avg',sig1_str));
     end
        xlswrite(name_sum,entry_sum_avg.omit,sprintf('%s Omit Pre-press entry Avg',sig1_str));
        
        
        xlswrite(name_sum,run_list',sprintf('%s Correct sessions',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Omission sessions',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Press sessions',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Last press sess',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Persev press sess',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Reward sessions',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s All Pre-press entry sess',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Corr Pre-press entry sess',sig1_str),'A1');
        xlswrite(name_sum,run_list',sprintf('%s Omit Pre-press entry sess',sig1_str),'A1');
        
        xlswrite(name_sum,cnum_total',sprintf('%s Correct sessions',sig1_str),'A2');
        xlswrite(name_sum,onum_total',sprintf('%s Omission sessions',sig1_str),'A2');
        xlswrite(name_sum,p1num_total',sprintf('%s Press sessions',sig1_str),'A2');
        xlswrite(name_sum,plnum_total',sprintf('%s Last press sess',sig1_str),'A2');
        xlswrite(name_sum,ppnum_total',sprintf('%s Persev press sess',sig1_str),'A2');
        xlswrite(name_sum,r1num_total',sprintf('%s Reward sessions',sig1_str),'A2');
        xlswrite(name_sum,enumall_total',sprintf('%s All Pre-press entry sess',sig1_str),'A2');
        if isempty(enumcorr_total)== 0
        xlswrite(name_sum,enumcorr_total',sprintf('%s Corr Pre-press entry sess',sig1_str),'A2');
        end
        xlswrite(name_sum,enumomit_total',sprintf('%s Omit Pre-press entry sess',sig1_str),'A2')
        
        
        xlswrite(name_sum,sig1_avg_total.correct,sprintf('%s Correct sessions',sig1_str),'A3');
        xlswrite(name_sum,sig1_avg_total.omission,sprintf('%s Omission sessions',sig1_str),'A3');
        xlswrite(name_sum,press_avg_total.press1,sprintf('%s Press sessions',sig1_str),'A3');
        xlswrite(name_sum,press_avg_total.presslast,sprintf('%s Last press sess',sig1_str),'A3');
        xlswrite(name_sum,press_avg_total.presspersev,sprintf('%s Persev press sess',sig1_str),'A3');
        if isempty(reward_avg_total.rew1)== 0
       xlswrite(name_sum,reward_avg_total.rew1,sprintf('%s Reward sessions',sig1_str),'A3');
        end
        xlswrite(name_sum,entry_avg_total.all,sprintf('%s All Pre-press entry sess',sig1_str),'A3');
        if isempty(entry_avg_total.corr)== 0
       xlswrite(name_sum,entry_avg_total.corr,sprintf('%s Corr Pre-press entry sess',sig1_str),'A3');
        end
        xlswrite(name_sum,entry_avg_total.omit,sprintf('%s Omit Pre-press entry sess',sig1_str),'A3');
        
        
        
        case 'No'
            return
    end
